import { system } from "@minecraft/server";
class Skunk {
    static IDENTIFIER = "sf_nba:skunk";
    static EVENT_ID = "sf_nba:skunk_spray";
    constructor() {
        this.initEvents();
    }
    initEvents() {
        system.afterEvents.scriptEventReceive.subscribe((eventData) => {
            const id = eventData.id;
            const entity = eventData.sourceEntity;
            if (id !== Skunk.EVENT_ID || entity.typeId !== Skunk.IDENTIFIER) return;
            const tameable = entity.getComponent("minecraft:tameable");
            const entityQuery = {
                location: entity.location,
                maxDistance: 6,
            }
            const nearbyEntities = entity.dimension.getEntities(entityQuery);
            const owner = tameable.tamedToPlayer;
            if (owner) {
                for (const target of nearbyEntities) {
                    if (target !== owner && target.typeId !== Skunk.IDENTIFIER) {
                        target.applyDamage(4)
                        target.addEffect("poison", 200);
                        target.addEffect("nausea", 100);
                    }
                }
            } else {
                for (const target of nearbyEntities) {
                    if (target.typeId !== Skunk.IDENTIFIER) {
                        target.addEffect("poison", 200);
                        target.addEffect("nausea", 100);
                    }
                }
            }
        });
    }
}
new Skunk();